/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import music.Main;
import music.commonUtils;
import music.getFrequency;
import music.settings;

public class getBackgroundNoise
extends JLabel
implements Runnable {
    private String[] userInput = new String[]{"A", "0"};
    private JProgressBar pb;
    private double[] amplitudes = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private int count = 0;
    private JFrame frame;
    private boolean micWorks = true;
    private static final long serialVersionUID = 100L;

    public getBackgroundNoise(JFrame e) {
        this.frame = e;
    }

    public boolean calc() {
        this.pb = new JProgressBar(0, 9);
        this.pb.setPreferredSize(new Dimension(225, 20));
        this.pb.setValue(1);
        JFrame dummy = new JFrame();
        dummy.setIconImage(Main.imgIcon);
        JDialog dialog = new JDialog((Frame)dummy, "Sampling Background Noise");
        dialog.getContentPane().add((Component)this.pb, "Center");
        dialog.pack();
        dialog.setVisible(true);
        dialog.setLocationRelativeTo(this.frame);
        new Thread((Runnable)this, "BackgroundNoise").start();
        Graphics g = this.pb.getGraphics();
        while (this.amplitudes[9] == 0.0) {
            if (this.pb.getValue() != this.count) {
                this.pb.setValue(this.count);
                this.pb.update(g);
            }
            if (this.micWorks) continue;
        }
        dialog.dispose();
        double noise = commonUtils.avg(this.amplitudes);
        if (!this.micWorks) {
            return false;
        }
        settings.backgroundNoise = noise;
        settings.write(noise);
        return true;
    }

    public void run() {
        AudioFormat linearFormat = commonUtils.getAudioFormat();
        byte[] voiceData = new byte[(int)linearFormat.getSampleRate()];
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, linearFormat);
        File audioFile = new File("sample.wav");
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(linearFormat);
        }
        catch (Exception e) {
            if (Main.debugErrors) {
                e.printStackTrace();
            }
            this.micWorks = false;
            return;
        }
        AudioInputStream linearStream = new AudioInputStream(targetDataLine);
        while (this.count < 10) {
            block6: {
                getFrequency.record(voiceData, linearFormat, info, audioFile, linearStream, targetDataLine);
                try {
                    this.userInput = getFrequency.frequency(audioFile);
                }
                catch (IOException ex) {
                    if (!Main.debugErrors) break block6;
                    System.out.println(ex);
                }
            }
            this.amplitudes[this.count] = Float.parseFloat(this.userInput[1]);
            ++this.count;
        }
        targetDataLine.stop();
        targetDataLine.close();
        voiceData = null;
        linearFormat = null;
        info = null;
        audioFile = null;
        targetDataLine = null;
        linearStream = null;
    }
}

